<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2021 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/
if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

require_once DIR_EXT. "ups_integration" . DIR_EXT_CORE ."helpers.php";
require_once DIR_EXT. "ups_integration" . DIR_EXT_CORE ."updater.php";

class ExtensionUpsIntegration extends Extension {

    public $data=[];
    public function __construct() {
        $this->registry = Registry::getInstance();
    }

    private function _is_enabled() {
        return $this->baseObject->config->get('ups_integration_status') ? $this->verify() : false;
    }

	public function verify() {
    	$that =& $this->baseObject;
		$exist = $that->db->query("SHOW TABLES LIKE '".$that->db->table('ups_integration_license')."'");
		if ($exist->num_rows === 1) {
			$validation = upsIntegrationVerifyLicense();
			if ( $validation['notification_case'] === 'notification_license_ok' ) {
				return true;
			} elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
				return false;
			}
		} else {
			return false;
		}
	}

	public function onControllerPagesExtensionExtensions_InitData() {
		$that =& $this->baseObject;
		if ($this->baseObject_method === 'edit') {
			$extension=$that->request->get['extension'];
			if ($extension==='ups_integration') {
				if ($that->request->is_POST() ) {
					$exist = $that->db->query("SHOW TABLES LIKE '".$that->db->table('ups_integration_license')."'");
					if ($exist->num_rows === 1) {
						if ($this->verify()===true) {
							upsIntegrationUninstallLicense();
						} else {
							$that->db->query("DROP TABLE IF EXISTS ".$that->db->table('ups_integration_license'));
						}
						upsIntegrationInstallLicense( $that->request->post['ups_integration_license_code'] );
					} else {
						$license = upsIntegrationInstallLicense( $that->request->post['ups_integration_license_code'] );
						if ( $license['notification_case'] !== 'notification_license_ok' ) {
							$that->session->data['error'] = $license['notification_text'];
						} else {
							$that->session->data['success'] = "The license key is valid";
						}
					}
				}
			}
		}
	}

	public function onControllerResponsesListingGridExtension_UpdateData() {
		$that =& $this->baseObject;
		if ($this->baseObject_method==='update') {
			if ($that->request->post['ups_integration_license_code']) {
				$exist = $that->db->query("SHOW TABLES LIKE '".$that->db->table('ups_integration_license')."'");
				if ($exist->num_rows === 1) {
					if ($this->verify()===true) {
						upsIntegrationUninstallLicense();
					} else {
						$that->db->query("DROP TABLE IF EXISTS ".$that->db->table('ups_integration_license'));
					}
					upsIntegrationInstallLicense( $that->request->post['ups_integration_license_code'] );
				} else {
					$license = upsIntegrationInstallLicense( $that->request->post['ups_integration_license_code'] );
					if ( $license['notification_case'] !== 'notification_license_ok' ) {
						$that->session->data['error'] = $license['notification_text'];
					} else {
						$that->session->data['success'] = "The license key is valid";
					}
				}
			}
		}
	}

    public function onControllerCommonHead_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        if (IS_ADMIN === false) {
            $that = $this->baseObject;
            $rt=$that->request->get['rt'];
            if ($rt==='checkout/cart') {
		            if ( $that->config->get( 'ups_integration_estimate_message' ) ) {
			            $message = htmlspecialchars_decode( trim( $that->config->get( 'ups_integration_estimate_message' ) ) );
			            $that->view->assign( 'estimate_message', $message );
		            } elseif ( $that->config->get( 'fedex_integration_status' ) === '1' && $that->config->get( 'fedex_integration_estimate_message' ) ) {
			            $message = htmlspecialchars_decode( trim( $that->config->get( 'fedex_integration_estimate_message' ) ) );
			            $that->view->assign( 'estimate_message', $message );
		            }
		            $local_ups_message = $that->config->get( 'ups_integration_local_delivery_message' );
		            if ( $local_ups_message ) {
			            $local_ups_message = htmlspecialchars_decode( $local_ups_message );
			            $that->view->assign( 'local_ups_message', trim( $local_ups_message ) );
		            }
		            $that->processTemplate( DIR_EXT . 'ups_integration/storefront/view/default/template/common/head.post.tpl' );
	            }
        }
    }

    public function onControllerResponsesEmbedHead_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        if (IS_ADMIN === false) {
            $that = $this->baseObject;
            $rt=$that->request->get['rt'];
            if ($rt==='r/checkout/cart/embed') {

		            if ( $that->config->get( 'ups_integration_estimate_message' ) ) {
			            $message = htmlspecialchars_decode( trim( $that->config->get( 'ups_integration_estimate_message' ) ) );
			            $that->view->assign( 'estimate_message', $message );
		            } elseif ( $that->config->get( 'fedex_integration_status' ) === '1' && $that->config->get( 'fedex_integration_estimate_message' ) ) {
			            $message = htmlspecialchars_decode( trim( $that->config->get( 'fedex_integration_estimate_message' ) ) );
			            $that->view->assign( 'estimate_message', $message );
		            }
		            $local_ups_message = $that->config->get( 'ups_integration_local_delivery_message' );
		            if ( $local_ups_message ) {
			            $local_ups_message = htmlspecialchars_decode( $local_ups_message );
			            $that->view->assign( 'local_ups_message', trim( $local_ups_message ) );
		            }
	            }
	            $that->processTemplate( DIR_EXT . 'ups_integration/storefront/view/default/template/embed/head.post.tpl' );
            }
    }

    public function onControllerResponsesCheckoutCart_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'change_zone_get_shipping_methods') {
		        $that->loadModel( 'localisation/country' );
		        $that->loadModel( 'localisation/zone' );
		        $country_info     = $that->model_localisation_country->getCountry( $that->request->post['country_id'] );
		        $zone_info        = $that->model_localisation_zone->getZone( $that->request->post['zone_id'] );
		        $shipping_address = [
			        'postcode'          => $that->request->post['postcode'],
			        'country_id'        => $that->request->post['country_id'],
			        'country_iso_code2' => $country_info['iso_code_2'],
			        'iso_code_2'        => $country_info['iso_code_2'],
			        'zone_id'           => $that->request->post['zone_id'],
			        'zone_code'         => $zone_info['code']
		        ];
		        $local_only       = $that->config->get( 'ups_integration_local_delivery_only' );
		        $postcode         = str_replace( ' ', '', strtoupper( $shipping_address['postcode'] ) );

		        $exclude_zipcodes = $that->config->get( 'ups_integration_local_zipcodes' );
		        $zipcodes_list    = explode( ',', $exclude_zipcodes );

		        $cart = $that->cart;
		        $valid = '';
		        if ( $zipcodes_list ) {
			        foreach ( $zipcodes_list as $zipcodes ) {
				        if ( fnmatch( $zipcodes, $postcode ) ) {
					        $valid = '1';
					        break;
				        }
			        }
		        } else {
			        if ( fnmatch( $exclude_zipcodes, $postcode ) ) {
				        $valid = '1';
			        }
		        }

		        //skip shipping processing if not required.
		        if ( $cart->hasShipping() ) {
			        if ( $local_only && $valid ) {
				        unset( $that->session->data['shipping_methods']['ups_integration'] );
			        }
			        $that->load->model( 'extension/ups_integration' );
			        $quote = $that->model_extension_ups_integration->getLocalDelivery( $shipping_address );
			        if ( $quote['quote'] ) {
				        $quotes_data['ups_integration_local'] = [
					        'title'      => $that->language->get( 'text_ups_local_delivery', 'ups_integration/ups_integration' ),
					        'quote'      => $quote['quote'],
					        'sort_order' => $quote['sort_order'],
					        'error'      => $quote['error']
				        ];
			        }

			        $quote_data = $that->session->data['shipping_methods'];
			        if ( $quotes_data ) {
				        $quote_data = array_merge( $quote_data, $quotes_data );
			        }
			        $sort_order  = [];
			        $total_quote = sizeof( $quote_data );
			        if ( $total_quote > 1 ) {
				        foreach ( $quote_data as $key => $value ) {
					        $sort_order[ $key ] = $value['sort_order'];
				        }
				        array_multisort( $sort_order, SORT_ASC, $quote_data );
			        }

			        $that->session->data['shipping_methods'] = $quote_data;
			        $output                                  = $that->session->data['shipping_methods'];

			        //add ready selectbox element
			        if ( sizeof( $output ) ) {
				        $disp_ship = [];
				        foreach ( $output as $shp_data ) {
					        $shp_data['quote'] = (array) $shp_data['quote'];
					        foreach ( $shp_data['quote'] as $qt_data ) {
						        $disp_ship[ $qt_data['id'] ] = $qt_data['title'] . " - " . $qt_data['text'];
					        }
				        }

				        if ( $disp_ship ) {
					        $selectbox           = HtmlElementFactory::create( [
						        'type'    => 'selectbox',
						        'name'    => 'shippings',
						        'options' => $disp_ship,
						        'style'   => 'large-field'
					        ] );
					        $output['selectbox'] = $selectbox->getHTML();
				        } else {
					        $output['selectbox'] = '';
				        }
			        }

		        } else {
			        $output['selectbox'] = '';
		        }

		        $that->data = $output;
        }
    }

    public function onControllerPagesCheckoutShipping_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
		        $that->load->language( 'ups_integration/ups_integration' );
		        $that->loadModel( 'account/address' );
		        $shipping_address = $that->model_account_address->getAddress( $that->session->data['shipping_address_id'] );

		        $local_only = $that->config->get( 'ups_integration_local_delivery_only' );
		        $postcode   = str_replace( ' ', '', strtoupper( $shipping_address['postcode'] ) );

		        $exclude_zipcodes = $that->config->get( 'ups_integration_local_zipcodes' );
		        $zipcodes_list    = explode( ',', $exclude_zipcodes );
		        if ( $zipcodes_list ) {
			        foreach ( $zipcodes_list as $zipcodes ) {
				        if ( fnmatch( $zipcodes, $postcode ) ) {
					        $valid = '1';
					        break;
				        }
			        }
		        } else {
			        if ( fnmatch( $exclude_zipcodes, $postcode ) ) {
				        $valid = '1';
			        }
		        }

		        if ( $local_only && $valid ) {
			        unset( $that->session->data['shipping_methods']['ups_integration'] );
		        }
		        $that->load->model( 'checkout/extension' );
		        $that->load->model( 'extension/ups_integration' );
		        $quote = $that->model_extension_ups_integration->getLocalDelivery( $shipping_address );
		        if ( $quote['quote'] ) {
			        $quotes_data['ups_integration_local'] = [
				        'title'      => $that->language->get( 'text_ups_local_delivery', 'ups_integration/ups_integration' ),
				        'quote'      => $quote['quote'],
				        'sort_order' => $quote['sort_order'],
				        'error'      => $quote['error']
			        ];
		        }

		        $quote_data = $that->session->data['shipping_methods'];
		        if ( $quotes_data ) {
			        $quote_data = array_merge( $quote_data, $quotes_data );
		        }
		        $sort_order  = [];
		        $total_quote = sizeof( $quote_data );
		        if ( $total_quote > 1 ) {
			        foreach ( $quote_data as $key => $value ) {
				        $sort_order[ $key ] = $value['sort_order'];
			        }
			        array_multisort( $sort_order, SORT_ASC, $quote_data );
		        }
		        $that->session->data['shipping_methods'] = $quote_data;
		        $this->data['shipping_methods']          = $that->session->data['shipping_methods'] ? $that->session->data['shipping_methods'] : [];
		        $shipping                                = $that->session->data['shipping_method']['id'];
		        if ( $this->data['shipping_methods'] ) {
			        foreach ( $this->data['shipping_methods'] as $k => $v ) {
				        if (empty($v['quote']) || $v['quote']===null) {
					        unset($this->data['shipping_methods'][$k]);
					        continue;
				        }

				        foreach ( $v['quote'] as $key => $val ) {
					        //check if we have only one method and select by default if was selected before
					        $selected = false;
					        if ( sizeof( $this->data['shipping_methods'] ) == 1 && sizeof( $v['quote'] ) == 1 ) {
						        $selected = true;
					        } else if ( $shipping == $val['id'] ) {
						        $selected = true;
					        }

					        $this->data['shipping_methods'][ $k ]['quote'][ $key ]['radio'] = $that->html->buildElement(
						        [
							        'type'    => 'radio',
							        'id'      => $val['id'],
							        'name'    => 'shipping_method',
							        'options' => [ $val['id'] => '' ],
							        'value'   => $selected
						        ] );
				        }
			        }
		        } else {
			        $this->data['shipping_methods'] = [];
		        }

		        $that->view->assign( 'shipping_methods', $this->data['shipping_methods'] );
        }
    }

    public function onControllerPagesCheckoutGuestStep2_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $cart = $that->cart;
            if ($cart->hasShipping()) {
                if (isset($that->session->data['guest']['shipping'])) {
                    $shipping_address = $that->session->data['guest']['shipping'];
                } else {
                    $shipping_address = $that->session->data['guest'];
                }
                $local_only = $that->config->get('ups_integration_local_delivery_only');
                $postcode = str_replace(' ', '', strtoupper($shipping_address['postcode']));

                $exclude_zipcodes = $that->config->get('ups_integration_local_zipcodes');
                $zipcodes_list = explode(',', $exclude_zipcodes);
                $valid = '';
                if ($zipcodes_list) {
                    foreach ($zipcodes_list as $zipcodes) {
                        if (fnmatch($zipcodes, $postcode)) {
                            $valid = '1';
                            break;
                        }
                    }
                } else {
                    if (fnmatch($exclude_zipcodes, $postcode)) {
                        $valid = '1';
                    }
                }
                if ($local_only && $valid) {
                    unset($that->session->data['shipping_methods']['ups_integration']);
                }
                $that->load->model('checkout/extension');
                $that->load->model('extension/ups_integration');
                $quote = $that->model_extension_ups_integration->getLocalDelivery($shipping_address);
                if ($quote['quote']) {
                    $quotes_data['ups_integration_local'] = [
                        'title' => $that->language->get('text_ups_local_delivery', 'ups_integration/ups_integration'),
                        'quote' => $quote['quote'],
                        'sort_order' => $quote['sort_order'],
                        'error' => $quote['error']
                    ];
                }

                $quote_data = $that->session->data['shipping_methods'];
                if ($quotes_data) {
                    $quote_data = array_merge($quote_data, $quotes_data);
                }
                $total_quote = sizeof($quote_data);
                if ($total_quote > 1) {
                    foreach ($quote_data as $key => $value) {
                        $sort_order[$key] = $value['sort_order'];
                    }
                    array_multisort($sort_order, SORT_ASC, $quote_data);
                }
                $that->session->data['shipping_methods'] = $quote_data;

                $this->data['shipping_methods'] = $that->session->data['shipping_methods'] ? $that->session->data['shipping_methods'] : [];

                $shipping = isset($that->request->post['shipping_method']) ? $that->request->post['shipping_method'] : $that->session->data['shipping_method']['id'];
                if ($this->data['shipping_methods']) {
                    foreach ($this->data['shipping_methods'] as $k => $v) {
                        if (empty($v['quote']) || $v['quote'] === null) {
                            unset($this->data['shipping_methods'][$k]);
                            continue;
                        }
                        foreach ($v['quote'] as $key => $val) {
                            $this->data['shipping_methods'][$k]['quote'][$key]['radio'] = $that->html->buildElement([
                                'type' => 'radio',
                                'id' => $val['id'],
                                'name' => 'shipping_method',
                                'options' => [$val['id'] => ''],
                                'value' => ($shipping == $val['id'] ? true : false)
                            ]);
                        }
                    }
                } else {
                    $this->data['shipping_methods'] = [];
                }
                $that->view->assign('shipping_methods', $this->data['shipping_methods']);

                $total = $cart->buildTotalDisplay();
                $this->data['order_totals'] = $total;
                $psettings = [];
                $ext_setgs = [];
                $results = $that->model_checkout_extension->getExtensions('payment');
                foreach ($results as $result) {
                    #filter only allowed payment methods based on total min/max
                    $pkey = $result['key'];
                    $psettings[$pkey] = $that->model_checkout_extension->getSettings($pkey);
                    $min = $psettings[$pkey][$pkey . "_payment_minimum_total"];
                    $max = $ext_setgs[$pkey][$pkey . "_payment_maximum_total"];
                    if ((has_value($min) && $total['total'] < $min)
                        || (has_value($max) && $total['total'] > $max)
                    ) {
                        continue;
                    }

                    $that->loadModel('extension/' . $pkey);
                    $method = $that->{'model_extension_' . $pkey}->getMethod($that->session->data['guest']);
                    foreach ($method as $k => $v) {
                        if ($k === 'id') {
                            $method['title'] = $that->language->get('text_title', $v . '/' . $v);
                        }
                    }
                    if ($method) {
                        $method_data[$pkey] = $method;
                        $method_data[$pkey]['extension_id'] = $result['extension_id'];

                        //# Add storefront icon if available
                        $icon = $psettings[$pkey][$pkey . "_payment_storefront_icon"];
                        if (has_value($icon)) {
                            $icon_data = $that->model_checkout_extension->getSettingImage($icon);
                            $icon_data['image'] = is_numeric($icon)
                                ? $icon_data['type_dir'] . '/' . $icon_data['resource_path']
                                : $icon;
                            $method_data[$result['key']]['icon'] = $icon_data;
                        }
                        //check if this is a redirect type of the payment
                        if ($psettings[$pkey][$pkey . "_redirect_payment"]) {
                            $method_data[$pkey]['is_redirect_payment'] = true;
                        }
                    }
                }
                //sort payments
                $sort_order = [];
                foreach ($method_data as $key => $value) {
                    $sort_order[$key] = $value['sort_order'];
                }

                array_multisort($sort_order, SORT_ASC, $method_data);
                $that->session->data['payment_methods'] = $method_data;
                $payment = isset($that->request->post['payment_method']) ? $that->request->post['payment_method'] : $that->session->data['payment_method']['id'];

                if ($that->session->data['payment_methods']) {
                    if ($that->session->data['shipping_methods']) {
                        //build array with payments available per each shipping
                        foreach ($that->session->data['shipping_methods'] as $method_name => $method_val) {
                            #Check config of selected shipping method and see if we have accepted payments restriction
                            $ship_ext_config = $that->model_checkout_extension->getSettings($method_name);
                            $accept_payment_ids = $ship_ext_config[$method_name . "_accept_payments"];
                            if (is_array($accept_payment_ids) && sizeof($accept_payment_ids)) {
                                #filter only allowed payment methods
                                $ac_payments = [];
                                foreach ($that->session->data['payment_methods'] as $key => $res_payment) {
                                    if (in_array($res_payment['extension_id'], $accept_payment_ids)) {
                                        $ac_payments[$key] = $res_payment;
                                    }
                                }
                            } else {
                                $ac_payments = $that->session->data['payment_methods'];
                            }
                            foreach ($ac_payments as $key => $value) {
                                $selected = false;
                                if ($payment == $value['id']) {
                                    $selected = true;
                                } else if ($psettings[$key][$key . "_autoselect"]) {
                                    $selected = true;
                                }
                                $this->data['payment_methods'][$method_name][$key] = $value;
                                $this->data['payment_methods'][$method_name][$key]['radio'] = $that->html->buildRadio([
                                    'type' => 'radio',
                                    'name' => 'payment_method',
                                    'options' => [$value['id'] => ''],
                                    'value' => $selected
                                ]);
                            }
                        }
                    } else {
                        //no shipping available show one set of payments
                        foreach ($that->session->data['payment_methods'] as $key => $value) {
                            $selected = false;
                            if ($payment == $value['id']) {
                                $selected = true;
                            } else if ($psettings[$key][$key . "_autoselect"]) {
                                $selected = true;
                            }
                            $this->data['payment_methods']['no_shipping'][$key] = $value;
                            $this->data['payment_methods']['no_shipping'][$key]['radio'] = $that->html->buildRadio([
                                'type' => 'radio',
                                'name' => 'payment_method',
                                'options' => [$value['id'] => ''],
                                'value' => $selected
                            ]);
                        }
                    }
                } else {
                    $this->data['payment_methods'] = [];
                }

                $that->view->assign('payment_methods', $this->data['payment_methods']);
            }
        }
    }

    public function onControllerPagesSaleOrder_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;

        if ($this->baseObject_method === 'recalc') {
	        $order_id    = $that->request->get['order_id'];
		        $skip_recalc = [];
		        $new_totals  = [];
		        //$log_msg = '';

		        if ( ! $that->user->canModify( 'sale/order' ) ) {
			        $that->session->data['error'] = $that->language->get( 'error_permission' );

			        return 0;
		        } else if ( ! has_value( $order_id ) ) {
			        $that->session->data['error'] = "Missing required details";

			        return 0;
		        }

		        //do we have to skip recalc for some totals?
		        if ( $that->request->get['skip_recalc'] ) {
			        $enc         = new AEncryption( $that->config->get( 'encryption_key' ) );
			        $skip_recalc = unserialize( $enc->decrypt( $that->request->get['skip_recalc'] ) );
		        }
		        //do we have total values passed?
		        if ( $that->request->post['totals'] ) {
			        $new_totals = $that->request->post['totals'];
		        }

		        //do we need to add new total record?
		        /**
		         * @var $adm_order_mdl ModelSaleOrder
		         */

		        include_once DIR_EXT . 'ups_integration' . DIR_EXT_CORE . 'lib/order_manager.php';
		        $order = new AUPSOrderManager( $order_id );
		        //Recalc. If total has changed from original, update and create a log to order history
		        $t_ret = $order->recalcTotals( $skip_recalc, $new_totals );
		        if ( ! $t_ret || $t_ret['error'] ) {
			        $that->session->data['error'] = "Error recalculating totals! " . $t_ret['error'];
		        } else {
			        $that->session->data['success'] = $that->language->get( 'text_success' );
		        }
	        }
    }

    private function redirect($url) {
        header('Location: ' . str_replace('&amp;', '&', $url));
        die();
    }

    protected function dispatch($dispatch_rt, $args = ['']) {
        return new ADispatcher($dispatch_rt, $args);
    }
    
    public function onControllerCommonHead_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            if (IS_ADMIN) {
                $support = upsIntegrationVerifySupport();
                 if ($support['notification_case'] === 'notification_license_ok') {
                    $that->load->language('ups_integration/ups_integration');
                    $getVersions = upsIntegrationUpdaterGetAllVersions();
                    $that->load->model('extension/ups_integration_updater');
                    $current_version = $that->model_extension_ups_integration_updater->getCurrentVersion();
                    if ($getVersions['notification_case'] !== 'notification_product_no_versions') {
                        $versions = $getVersions['notification_data']['product_versions'];
                        $total = $that->model_extension_ups_integration_updater->getTotalMsgIds();
                        if ($total > '0') {
                            $msg_ids = $that->model_extension_ups_integration_updater->getMsgIdsByCartVersions();
                            foreach ($msg_ids as $msg_id) {
                                $that->messages->deleteMessage($msg_id['msg_id']);
                                $that->model_extension_ups_integration_updater->deleteMsgID($msg_id['msg_id']);
                            }
                        }
                        if ($versions) {
                            $latestVersions = [];
                            foreach ($versions as $version) {
                                if (strpos($version['version_number'], VERSION) !== false) {
                                    $latestVersions[] = $version['version_number'];
                                }
                            }
                            usort($latestVersions, 'version_compare');
                            $latestVersion = end($latestVersions);
                            if (version_compare($current_version, $latestVersion, '<') === true) {
                                $msg_ids = $that->model_extension_ups_integration_updater->getMsgIdsByCurrentCartVersion();
                                foreach ($msg_ids as $msg_id) {
                                    $that->messages->deleteMessage($msg_id['msg_id']);
                                    $that->model_extension_ups_integration_updater->deleteMsgID($msg_id['msg_id']);
                                }
                                $msg_title = str_replace('[new_version]', $latestVersion, $that->language->get('text_new_ups_integration_version_title'));
                                $msg = str_replace('[version_number]', str_replace('.', '-', $latestVersion), $that->language->get('text_new_ups_integration_version_description'));
                                $that->messages->saveNotice($msg_title, $msg);
                                $msg_info = $that->messages->getLikeMessage($msg_title);
                                $that->model_extension_ups_integration_updater->saveMessageId($msg_info['msg_id'], $latestVersion);
                            }
                        }
                    }
                }
            }
        }
    }
}