(function () {
    var email = (function () {
        'use strict';
        tinymce.PluginManager.add('email', function (editor, url) {
            // Add a button that opens a window
            editor.ui.registry.addButton('email', {
                text: 'E-Mail',
                onAction: () => {
                    editor.windowManager.open({
                        title: 'E-Mail Address',
                        body: {
                            type: 'panel',
                            items: [{
                                type: 'input',
                                name: 'title',
                                label: 'E-Mail',
                            }],
                        },
                        onSubmit: function (api) {
                            // Insert content when the window form is submitted
                            editor.insertContent('<a href="mailto:' + api.getData().title + '">' + api.getData().title + '</a>&nbsp;');
                            api.close();
                        },
                        buttons: [
                            {
                                text: 'Close',
                                type: 'cancel',
                                onclick: 'close'
                            },
                            {
                                text: 'Insert',
                                type: 'submit',
                                primary: true,
                                enabled: false
                            }
                        ]
                    });
                }
            });

            // Adds a menu item to the tools menu
            editor.ui.registry.addMenuItem('email', {
                text: 'E-Mail',
                context: 'insert',
                onAction: () => {
                    editor.windowManager.open({
                        title: 'E-Mail Address',
                        body: {
                            type: 'panel',
                            items: [{
                                type: 'input',
                                name: 'title',
                                label: 'E-Mail',
                            }],
                        },
                        onSubmit: function (api) {
                            // Insert content when the window form is submitted
                            editor.insertContent('<a href="mailto:' + api.getData().title + '">' + api.getData().title + '</a>&nbsp;');
                            api.close();
                        },
                        buttons: [
                            {
                                text: 'Close',
                                type: 'cancel',
                                onclick: 'close'
                            },
                            {
                                text: 'Insert',
                                type: 'submit',
                                primary: true,
                                enabled: false
                            }
                        ]
                    });
                }
            });
        });
    }());
})();