<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2021 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/
if ( ! defined( 'DIR_CORE' ) ) {
	header( 'Location: static_pages/' );
}

/**
 * Class ControllerResponsesOptionPriceProduct
 * @property ModelOptionPriceProOptions $model_option_price_pro_options
 * @property ModelOptionPriceProProductOptions $model_option_price_pro_product_options
 * @property ModelAdvancedReportsProductOptions $model_advanced_reports_product_options
 */
class ControllerResponsesOptionPriceProProduct extends AController {
	public $error = array();
	public $data = array();
	/**
	 * @var AAttribute_Manager
	 */
	private $attribute_manager;

	public function verifyAdvancedReportsStatus() {
		if ( $this->config->get( 'advanced_reports_status' ) === '1' ) {
			$exist = $this->db->query("SHOW TABLES LIKE '".$this->db->table('advanced_reports_license')."'");
			if ($exist->num_rows === 1) {
				$validation = advancedReportsVerifyLicense();
				if ( $validation['notification_case'] === 'notification_license_ok' ) {
					return true;
				} elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
					return false;
				}
			} else {
				return false;
			}
		} else {
			return false;
		}
	}

	public function verify() {
		if ($this->config->get('option_price_pro_status') === '1') {
			$exist = $this->db->query("SHOW TABLES LIKE '".$this->db->table('option_pro_license')."'");
			if ($exist->num_rows === 1) {
				$validation = optionProVerifyLicense();
				if ( $validation['notification_case'] === 'notification_license_ok' ) {
					return true;
				} elseif ( $validation['notification_case'] === 'notification_license_corrupted' ) {
					return false;
				}
			} else {
				return false;
			}
		} else {
			return false;
		}
	}

	public function get_options_list() {

		//init controller data
		$this->extensions->hk_InitData( $this, __FUNCTION__ );

		$this->loadModel( 'catalog/product' );
		$product_options = $this->model_catalog_product->getProductOptions( $this->request->get['product_id'] );

		$result = array();
		foreach ( $product_options as $option ) {
			$option_name                            = trim( $option['language'][ $this->language->getContentLanguageID() ]['name'] );
			$result[ $option['product_option_id'] ] = $option_name ? $option_name : 'n/a';
		}

		//update controller data
		$this->extensions->hk_UpdateData( $this, __FUNCTION__ );

		$this->load->library( 'json' );
		$this->response->addJSONHeader();
		$this->response->setOutput( AJson::encode( $result ) );
	}

	public function update_option() {

		//init controller data
		$this->extensions->hk_InitData( $this, __FUNCTION__ );

		if ( ! $this->user->canModify( 'product/product' ) ) {
			$error = new AError( '' );

			return $error->toJSONResponse( 'NO_PERMISSIONS_402',
				array(
					'error_text'  => sprintf( $this->language->get( 'error_permission_modify' ), 'product/product' ),
					'reset_value' => true
				) );
		}
		//needs to validate attribute properties
		// first - prepare data for validation
		if ( ! isset( $this->request->get['required'] ) ) {
			$this->request->get['required'] = 0;
		}

		if ( has_value( $this->request->get['regexp_pattern'] ) ) {
			$this->request->get['regexp_pattern'] = trim( $this->request->get['regexp_pattern'] );
		}
		if ( has_value( $this->request->get['option_placeholder'] ) ) {
			$this->request->get['option_placeholder'] = trim( $this->request->get['option_placeholder'] );
		}

		$this->loadModel( 'catalog/product' );
		$this->loadModel( 'option_price_pro/options' );
		$data                      = $this->request->get;
		$attribute_manager = new AAttribute_Manager( 'product_option' );
		$option_info               = $this->model_catalog_product->getProductOption( $this->request->get['product_id'], $this->request->get['option_id'] );
		$data['element_type']      = $option_info['element_type'];
		$data['attribute_type_id'] = $attribute_manager->getAttributeTypeID( 'product_option' );

		$errors = $attribute_manager->validateAttributeCommonData( $data );
		if ( ! $errors ) {
			$this->model_option_price_pro_options->updateProductOption( $this->request->get['option_id'], $this->request->get );
			$data['minimum']        = $this->request->get['minimum'];
			$data['maximum']        = $this->request->get['maximum'];
			$data['maximum_status'] = $this->request->get['maximum_status'];
			$this->model_option_price_pro_options->addSettings( $this->request->get['option_id'], $data );
		} else {
			$error = new AError( '' );

			return $error->toJSONResponse( '',
				array( 'error_title' => implode( '<br>', $errors ) ) );
		}

		//update controller data
		$this->extensions->hk_UpdateData( $this, __FUNCTION__ );
	}

	public function load_option() {
		//init controller data
		$this->extensions->hk_InitData( $this, __FUNCTION__ );
		$this->loadLanguage( 'catalog/product' );
		$this->loadLanguage( 'option_price_pro/option_price_pro' );
		$this->document->setTitle( $this->language->get( 'heading_title' ) );
		$this->loadModel( 'catalog/product' );
		if ($this->verifyAdvancedReportsStatus()===true) {
			$this->loadLanguage( 'advanced_reports/advanced_reports' );
			$this->data['entry_option_cost'] = $this->language->get( 'entry_option_cost' );
			$this->data['report_status']     = '1';
		}

		if ($this->verify()===true) {
			$this->data['option_status'] = $this->config->get( 'option_price_pro_status' );
		}

		$this->view->assign( 'success', $this->session->data['success'] );
		unset( $this->session->data['success'] );

		$product_id = (int) $this->request->get['product_id'];
		$option_id  = (int) $this->request->get['option_id'];

		$this->data['option_data'] = $this->model_catalog_product->getProductOption( $product_id, $option_id );

		if ($this->data['option_data']) {

			$language_id               = $this->language->getContentLanguageID();
			$this->data['language_id'] = $language_id;

			$this->load->model( 'option_price_pro/options' );
			$option_settings = $this->model_option_price_pro_options->getSettings( $option_id );
			if ( is_null( $option_settings ) ) {
				$this->data['option_data']['minimum']        = '';
				$this->data['option_data']['maximum']        = '';
				$this->data['option_data']['maximum_status'] = false;
			} else {
				$this->data['option_data']['minimum']        = $option_settings['minimum'];
				$this->data['option_data']['maximum']        = $option_settings['maximum'];
				$this->data['option_data']['maximum_status'] = $option_settings['maximum_status'];
			}

			$this->data['element_types']         = HtmlElementFactory::getAvailableElements();
			$this->data['elements_with_options'] = HtmlElementFactory::getElementsWithOptions();
			$this->data['selectable']            = in_array( $this->data['option_data']['element_type'], $this->data['elements_with_options'] ) ? 1 : 0;
			$this->data['option_type']           = $this->data['element_types'][ $this->data['option_data']['element_type'] ]['type'];

			$this->attribute_manager = new AAttribute_Manager( 'product_option' );

			$this->data['action'] = $this->html->getSecureURL( 'r/option_price_pro/product/update_option_values', '&product_id=' . $product_id . '&option_id=' . $option_id );

			$this->data['option_values'] = $this->model_catalog_product->getProductOptionValues( $product_id, $option_id );

			$this->data['option_name'] = $this->html->buildElement( array(
				'type'  => 'input',
				'name'  => 'name',
				'value' => $this->data['option_data']['language'][ $this->data['language_id'] ]['name'],
				'style' => 'medium-field'
			) );

			if ( in_array( $this->data['option_data']['element_type'], HtmlElementFactory::getElementsWithPlaceholder() ) ) {
				$this->data['option_placeholder'] = $this->html->buildElement( array(
					'type'  => 'input',
					'name'  => 'option_placeholder',
					'value' => $this->data['option_data']['language'][ $this->data['language_id'] ]['option_placeholder'],
					'style' => 'medium-field'
				) );
			}

			$this->data['status'] = $this->html->buildElement( array(
				'type'  => 'checkbox',
				'name'  => 'status',
				'value' => $this->data['option_data']['status'],
				'style' => 'btn_switch btn-group-xs',
			) );

			$this->data['option_sort_order'] = $this->html->buildElement( array(
				'type'  => 'input',
				'name'  => 'sort_order',
				'value' => $this->data['option_data']['sort_order'],
				'style' => 'tiny-field'
			) );

			$this->data['required'] = $this->html->buildElement( array(
				'type'  => 'checkbox',
				'name'  => 'required',
				'value' => $this->data['option_data']['required'],
				'style' => 'btn_switch btn-group-xs',
			) );

			$this->data['calculate'] = $this->html->buildElement( array(
				'type'  => 'checkbox',
				'name'  => 'calculate',
				'value' => $this->data['option_data']['calculate'],
				'style' => 'btn_switch btn-group-xs',
			) );

			$this->data['base_price'] = $this->html->buildElement( array(
				'type'  => 'checkbox',
				'name'  => 'base_price',
				'value' => $this->data['option_data']['base_price'],
				'style' => 'btn_switch btn-group-xs',
			) );

			$type = $this->data['option_data']['element_type'];
			if ( $type === 'G' || $type === 'M' ) {
				$this->data['entry_maximum_status'] = $this->language->get( 'text_pro_maximum_status' );
				$this->data['maximum_status']       = $this->html->buildElement( array(
					'type'  => 'checkbox',
					'name'  => 'maximum_status',
					'value' => $this->data['option_data']['maximum_status'],
					'style' => 'btn_switch btn-group-xs',
				) );
				$this->data['entry_minimum']        = $this->language->get( 'enter_pro_minimum' );
				$this->data['minimum']              = $this->html->buildElement( array(
					'type'  => 'input',
					'name'  => 'minimum',
					'value' => $this->data['option_data']['minimum'],
					'style' => 'tiny-field'
				) );
				$this->data['entry_maximum']        = $this->language->get( 'enter_pro_maximum' );
				$this->data['maximum']              = $this->html->buildElement( array(
					'type'  => 'input',
					'name'  => 'maximum',
					'value' => $this->data['option_data']['maximum'],
					'style' => 'tiny-field'
				) );
			}

			//for file-option
			if ( $this->data['option_data']['element_type'] == 'U' ) {
				$option_settings = unserialize( $this->data['option_data']['settings'] );

				$this->data['extensions'] = $this->html->buildElement( array(
					'type'  => 'input',
					'name'  => 'settings[extensions]',
					'value' => $option_settings['extensions'],
					'style' => 'no-save'
				) );

				$this->data['min_size']  = $this->html->buildElement( array(
					'type'  => 'input',
					'name'  => 'settings[min_size]',
					'value' => $option_settings['min_size'],
					'style' => 'small-field no-save'
				) );
				$this->data['max_size']  = $this->html->buildElement( array(
					'type'  => 'input',
					'name'  => 'settings[max_size]',
					'value' => $option_settings['max_size'],
					'style' => 'small-field no-save'
				) );
				$this->data['directory'] = $this->html->buildElement( array(
					'type'  => 'input',
					'name'  => 'settings[directory]',
					'value' => $option_settings['directory'],
					'style' => 'no-save'
				) );

				$this->data['entry_upload_dir'] = sprintf( $this->language->get( 'entry_upload_dir' ), 'admin/system/upload/' );
			} else {
				$this->data['option_regexp_pattern'] = $this->html->buildElement( array(
					'type'  => 'input',
					'name'  => 'regexp_pattern',
					'value' => $this->data['option_data']['regexp_pattern'],
					'style' => 'medium-field'
				) );

				$this->data['option_error_text'] = $this->html->buildElement( array(
					'type'  => 'input',
					'name'  => 'error_text',
					'value' => $this->data['option_data']['language'][ $this->data['language_id'] ]['error_text'],
					'style' => 'medium-field'
				) );
			}
			$this->data['remove_option'] = $this->html->getSecureURL(
				'r/option_price_pro/product/del_option',
				'&product_id=' . $product_id . '&option_id=' . $option_id
			);

			$this->data['button_remove_option'] = $this->html->buildElement( array(
				'type'  => 'button',
				'text'  => $this->language->get( 'button_remove_option' ),
				'style' => 'button3',
				'href'  => $this->data['remove_option']
			) );
			$this->data['button_save']          = $this->html->buildElement( array(
				'type'  => 'button',
				'text'  => $this->language->get( 'button_save' ),
				'style' => 'button1',
			) );
			$this->data['button_reset']         = $this->html->buildElement( array(
				'type'  => 'button',
				'text'  => $this->language->get( 'button_reset' ),
				'style' => 'button2',
			) );

			$this->data['update_option_values'] = $this->html->getSecureURL(
				'r/option_price_pro/product/update_option_values',
				'&product_id=' . $product_id . '&option_id=' . $option_id
			);
			// form of option values list
			$form = new AForm( 'HT' );
			$form->setForm( array( 'form_name' => 'update_option_values' ) );
			$this->data['form']['id']                        = 'update_option_values';
			$this->data['update_option_values_form']['open'] = $form->getFieldHtml( array(
				'type'   => 'form',
				'name'   => 'update_option_values',
				'attr'   => 'data-confirm-exit="true" class="form-horizontal"',
				'action' => $this->data['update_option_values']
			) );

			//form of option
			$form = new AForm( 'HT' );
			$form->setForm( array(
				'form_name' => 'option_value_form',
			) );

			$this->data['form']['id']        = 'option_value_form';
			$this->data['form']['form_open'] = $form->getFieldHtml( array(
				'type'   => 'form',
				'name'   => 'option_value_form',
				'attr'   => 'data-confirm-exit="true"',
				'action' => $this->data['update_option_values']
			) );

			//Load option values rows
			foreach ( $this->data['option_values'] as $key => $item ) {
				$this->request->get['product_option_value_id'] = $item['product_option_value_id'];
				$this->data['option_values'][ $key ]['row']    = $this->_option_value_form( $form );
			}

			$this->data['new_option_row'] = '';
			if ( in_array( $this->data['option_data']['element_type'], $this->data['elements_with_options'] ) ) {
				$this->request->get['product_option_value_id'] = null;
				$this->data['new_option_row']                  = $this->_option_value_form( $form );
			}

			$this->view->batchAssign( $this->data );

		}

		if ( $this->data['option_data'] ) {
			$this->processTemplate( 'extensions/option_price_pro/admin/view/default/template/responses/product/option_values.tpl' );
		} else {
			$this->response->setOutput( '' );
		}
		//update controller data
		$this->extensions->hk_UpdateData( $this, __FUNCTION__ );
	}

	public function del_option() {
		//init controller data
		$this->extensions->hk_InitData( $this, __FUNCTION__ );

		if ( ! $this->user->canModify( 'product/product' ) ) {
			$error = new AError( '' );

			return $error->toJSONResponse( 'NO_PERMISSIONS_402',
				array(
					'error_text'  => sprintf( $this->language->get( 'error_permission_modify' ), 'product/product' ),
					'reset_value' => true
				) );
		}

		$this->loadLanguage( 'catalog/product' );
		$this->loadModel( 'catalog/product' );
		$this->loadModel( 'option_price_pro/options' );
		$this->model_catalog_product->deleteProductOption( $this->request->get['product_id'], $this->request->get['option_id'] );
		$this->model_option_price_pro_options->deleteSettings( $this->request->get['option_id'] );
		//update controller data
		$this->extensions->hk_UpdateData( $this, __FUNCTION__ );
		$this->response->setOutput( $this->language->get( 'text_option_removed' ) );
	}

	public function update_option_values() {
		//init controller data
		$this->extensions->hk_InitData( $this, __FUNCTION__ );

		if ( ! $this->user->canModify( 'product/product' ) ) {
			$error = new AError( '' );

			return $error->toJSONResponse( 'NO_PERMISSIONS_402',
				array(
					'error_text'  => sprintf( $this->language->get( 'error_permission_modify' ), 'product/product' ),
					'reset_value' => true
				) );
		}

		$this->loadLanguage( 'catalog/product' );
		$this->loadModel( 'catalog/product' );

		$option_info = $this->model_catalog_product->getProductOption( $this->request->get['product_id'], $this->request->get['option_id'] );
		//remove html-code from textarea product option
		if ( in_array( $option_info['element_type'], array( 'T', 'B' ) ) ) {
			foreach ( (array) $this->request->post['name'] as &$v ) {
				$v = strip_tags( html_entity_decode( $v, ENT_QUOTES, 'UTF-8' ) );
				$v = str_replace( '\r\n', "\n", $v );
			}
		}

		if ($this->verifyAdvancedReportsStatus()===true) {
			$this->loadModel( 'advanced_reports/product_options' );
			$this->model_advanced_reports_product_options->updateProductOptionValues( $this->request->get['product_id'], $this->request->get['option_id'], $this->request->post );
		} else {
			$this->model_catalog_product->updateProductOptionValues( $this->request->get['product_id'], $this->request->get['option_id'], $this->request->post );
		}

		foreach((array)$this->request->post['product_option_value_id'] as $product_option_value_id) {
			$stock_locations = $this->request->post['stock_location'][$product_option_value_id];
			if(!is_int(strpos($product_option_value_id,'new'))){
				$this->model_catalog_product->updateProductStockLocations(
					$stock_locations,
					$this->request->get['product_id'],
					$product_option_value_id);
			}
			}
		$this->session->data['success'] = $this->language->get( 'text_success_option' );

		//update controller data
		$this->extensions->hk_UpdateData( $this, __FUNCTION__ );

		$this->redirect( $this->html->getSecureURL( 'r/option_price_pro/product/load_option', '&product_id=' . $this->request->get['product_id'] . '&option_id=' . $this->request->get['option_id'] ) );
	}

	/**
	 * @param $form
	 *
	 * @return string
	 * @throws AException
	 */
	private function _option_value_form( $form ) {
		$this->load->model( 'option_price_pro/product_options' );
		$this->data['option_attribute']           = $this->attribute_manager->getAttributeByProductOptionId( $this->request->get['option_id'] );
		$this->data['option_attribute']['values'] = array();
		$this->data['option_attribute']['type']   = 'input';
		$product_option_value_id                  = $this->request->get['product_option_value_id'];
		$group_attribute                          = array();
		if ( $this->data['option_attribute']['attribute_id'] ) {
			$group_attribute = $this->attribute_manager->getAttributes( array(), $this->data['language_id'], $this->data['option_attribute']['attribute_id'] );
		}

		$this->data['elements_with_options'] = HtmlElementFactory::getElementsWithOptions();
		//load values for attributes with options
		if ( sizeof( $group_attribute ) ) {
			$this->data['option_attribute']['group'] = array();
			foreach ( $group_attribute as $attribute ) {
				$option_id                                                     = $attribute['attribute_id'];
				$this->data['option_attribute']['group'][ $option_id ]['name'] = $attribute['name'];
				$this->data['option_attribute']['group'][ $option_id ]['type'] = 'hidden';
				if ( in_array( $attribute['element_type'], $this->data['elements_with_options'] ) ) {
					$this->data['option_attribute']['group'][ $option_id ]['type'] = 'selectbox';
					$values                                                        = $this->attribute_manager->getAttributeValues( $attribute['attribute_id'], $this->language->getContentLanguageID() );
					foreach ( $values as $v ) {
						$this->data['option_attribute']['group'][ $option_id ]['values'][ $v['attribute_value_id'] ] = addslashes( html_entity_decode( $v['value'], ENT_COMPAT, 'UTF-8' ) );
					}
				}
			}
		} else {
			if ( in_array( $this->data['option_attribute']['element_type'], $this->data['elements_with_options'] ) ) {
				$this->data['option_attribute']['type'] = 'selectbox';
				if ( is_null( $product_option_value_id ) ) { // for new row values
					$values = $this->attribute_manager->getAttributeValues(
						$this->data['option_attribute']['attribute_id'],
						$this->language->getContentLanguageID()
					);
				} else {
					$values = $this->getProductOptionValues(
                                                $this->request->get['product_id'],
						$this->data['option_attribute']['attribute_id'],
						$this->language->getContentLanguageID()
					);
				}
				foreach ( $values as $v ) {
					$this->data['option_attribute']['values'][ $v['attribute_value_id'] ] = addslashes( html_entity_decode( $v['value'], ENT_COMPAT, 'UTF-8' ) );
				}
			}
		}

		$this->data['cancel'] = $this->html->getSecureURL( 'r/option_price_pro/product/load_option', '&product_id=' . $this->request->get['product_id'] . '&option_id=' . $this->request->get['option_id'] );

		if ( isset( $this->request->get['product_option_value_id'] ) ) {
			$this->data['row_id']      = 'row' . $product_option_value_id;
			$this->data['attr_val_id'] = $product_option_value_id;
			$item_info                 = $this->model_option_price_pro_product_options->getProductOptionValue( $this->request->get['product_id'], $product_option_value_id );
		} else {
			$this->data['row_id'] = 'new_row';
		}

		if ($this->verifyAdvancedReportsStatus()===true) {
			$fields = array(
				'default',
				'name',
				'sku',
				'quantity',
				'subtract',
				'price',
				'cost',
				'prefix',
				'sort_order',
				'weight',
				'weight_type',
				'attribute_value_id',
				'children_options'
			);
		} else {
			$fields = array(
				'default',
				'name',
				'sku',
				'quantity',
				'subtract',
				'price',
				'prefix',
				'sort_order',
				'weight',
				'weight_type',
				'attribute_value_id',
				'children_options'
			);
		}
		foreach ( $fields as $f ) {
			if ( isset( $this->request->post[ $f ] ) ) {
				$this->data[ $f ] = $this->request->post[ $f ];
			} elseif ( isset( $item_info ) ) {
				$this->data[ $f ] = $item_info[ $f ];
			} else {
				$this->data[ $f ] = '';
			}
		}

		if ( isset( $this->request->post['name'] ) ) {
			$this->data['name'] = $this->request->post['name'];
		} elseif ( isset( $item_info ) ) {
			$this->data['name'] = $item_info['language'][ $this->language->getContentLanguageID() ]['name'];
		}

		if ( isset( $this->data['option_attribute']['group'] ) ) {
			//process grouped (parent/child) options
			$this->data['form']['fields']['option_value'] = '';
			foreach ( $this->data['option_attribute']['group'] as $attribute_id => $data ) {
				$this->data['form']['fields']['option_value'] .= '<span style="white-space: nowrap;">' . $data['name'] . '' . $form->getFieldHtml( array(
						'type'    => $data['type'],
						'name'    => 'attribute_value_id[' . $product_option_value_id . '][' . $attribute_id . ']',
						'value'   => $this->data['children_options'][ $attribute_id ],
						'options' => $data['values'],
						'attr'    => ''
					) ) . '<span><br class="clr_both">';

			}
		} else {
			if ( in_array( $this->data['option_attribute']['element_type'], $this->data['elements_with_options'] ) ) {
				$this->data['form']['fields']['option_value'] = $form->getFieldHtml( array(
					'type'    => $this->data['option_attribute']['type'],
					'name'    => 'attribute_value_id[' . $product_option_value_id . ']',
					'value'   => $this->data['attribute_value_id'],
					'options' => $this->data['option_attribute']['values'],
				) );
			} else {
				if ( $this->data['option_attribute']['element_type'] == 'U' ) {
					//for file there is no option value
					$this->data['form']['fields']['option_value'] = '';
				} else {
					$arr = array(
						'type'  => in_array( $this->data['option_data']['element_type'], array(
							'T',
							'B'
						) ) ? 'textarea' : 'input',
						'name'  => 'name[' . $product_option_value_id . ']',
						'value' => $this->data['name']
					);
					// for checkbox show error when value is empty
					if ( $this->data['option_data']['element_type'] == 'C' && $this->data['name'] == '' ) {
						$arr['style'] = 'alert-danger';
					}
					$this->data['form']['fields']['option_value'] = $form->getFieldHtml( $arr );
				}
			}
		}

		$this->data['form']['fields']['product_option_value_id'] = $form->getFieldHtml( array(
			'type'  => 'hidden',
			'name'  => 'product_option_value_id[' . $product_option_value_id . ']',
			'value' => $product_option_value_id,
		) );

		if ( in_array( $this->data['option_data']['element_type'], $this->data['elements_with_options'] ) ) {
			$this->data['form']['fields']['default'] = $form->getFieldHtml( array(
				'type'    => 'radio',
				'name'    => 'default_value',
				'id'      => 'default_' . $product_option_value_id,
				'value'   => ( $this->data['default'] ? $product_option_value_id : '' ),
				'options' => array( $product_option_value_id => '' ),
			) );
			$this->data['with_default']              = 1;
		}

		$this->data['form']['fields']['sku'] = $form->getFieldHtml( array(
			'type'  => 'input',
			'name'  => 'sku[' . $product_option_value_id . ']',
			'value' => $this->data['sku'],
		) );
		$stock_locations                     = null;
		if ( $this->data['subtract'] ) {
			$stock_locations = $this->model_catalog_product->getProductStockLocations(
				(int) $this->request->get['product_id'],
				$product_option_value_id
			);
		}
		$this->data['form']['fields']['quantity'] = $form->getFieldHtml( array(
			'type'  => 'input',
			'name'  => 'quantity[' . $product_option_value_id . ']',
			'value' => $this->data['quantity'],
			'style' => 'small-field',
			'attr'  => ( $stock_locations && $this->data['subtract'] ? 'disabled' : '' )
		) );
		$this->data['form']['fields']['subtract'] = $form->getFieldHtml( array(
			'type'    => 'selectbox',
			'name'    => 'subtract[' . $product_option_value_id . ']',
			'value'   => $this->data['subtract'],
			'options' => array(
				1 => $this->language->get( 'text_yes' ),
				0 => $this->language->get( 'text_no' ),
			),
		) );
		$this->data['form']['fields']['price']    = $form->getFieldHtml( array(
			'type'  => 'input',
			'name'  => 'price[' . $product_option_value_id . ']',
			'value' => moneyDisplayFormat( $this->data['price'] ),
			'style' => 'medium-field'
		) );

		if ($this->verifyAdvancedReportsStatus()===true) {
			$this->data['report_status']          = '1';
			$this->data['form']['fields']['cost'] = $form->getFieldHtml( array(
				'type'  => 'input',
				'name'  => 'cost[' . $product_option_value_id . ']',
				'value' => moneyDisplayFormat( $this->data['cost'] ),
				'style' => 'medium-field'
			) );
		}

		$this->data['prefix'] = trim( $this->data['prefix'] );
		$currency_symbol      = $this->currency->getCurrency( $this->config->get( 'config_currency' ) );
		$currency_symbol      = $currency_symbol['symbol_left'] . $currency_symbol['symbol_right'];
		if ( ! $this->data['prefix'] ) {
			$this->data['prefix'] = $currency_symbol;
		}

		$this->data['form']['fields']['prefix']     = $form->getFieldHtml( array(
			'type'    => 'selectbox',
			'name'    => 'prefix[' . $product_option_value_id . ']',
			'value'   => $this->data['prefix'],
			'options' => array(
				'$' => $currency_symbol,
				'%' => '%'
			),
			'style'   => 'small-field'
		) );
		$this->data['form']['fields']['sort_order'] = $form->getFieldHtml( array(
			'type'  => 'input',
			'name'  => 'sort_order[' . $product_option_value_id . ']',
			'value' => $this->data['sort_order'],
			'style' => 'small-field',
		) );
		$this->data['form']['fields']['weight']     = $form->getFieldHtml( array(
			'type'  => 'input',
			'name'  => 'weight[' . $product_option_value_id . ']',
			'value' => $this->data['weight'],
			'style' => 'small-field',
		) );

		//build available weight units for options
		$wht_options = array( '%' => '%' );
		$this->loadModel( 'localisation/weight_class' );
		$selected_unit                           = trim( $this->data['weight_type'] );
		$prd_info                                = $this->model_catalog_product->getProduct( $this->request->get['product_id'] );
		$prd_weight_info                         = $this->model_localisation_weight_class->getWeightClass( $prd_info['weight_class_id'] );
		$wht_options[ $prd_weight_info['unit'] ] = $prd_weight_info['title'];

		$option_weight_class_id = '';
		if ( $selected_unit && $selected_unit != '%' ) {
			$a_weight               = new AWeight( $this->registry );
			$option_weight_class_id = $a_weight->getClassIDByUnit( $selected_unit );
		}

		if ( empty( $selected_unit ) ) {
			//no weight yet, use product weight unit as default
			$selected_unit = trim( $prd_weight_info['unit'] );
		} else {
			if ( $option_weight_class_id != trim( $prd_info['weight_class_id'] ) && $selected_unit != '%' ) {
				//main product type has changed. Show what weight unit we have in option
				$weight_info                   = $this->model_localisation_weight_class->getWeightClassDescriptionByUnit( $selected_unit );
				$wht_options[ $selected_unit ] = $weight_info['title'];
			}
		}
		$this->data['form']['fields']['weight_type'] = $form->getFieldHtml( array(
			'type'    => 'selectbox',
			'name'    => 'weight_type[' . $product_option_value_id . ']',
			'value'   => $selected_unit,
			'options' => $wht_options
		) );

		//do not show RL and stock locations for new row and options with multivalue such as checkboxgroup and multiselect
		if($product_option_value_id
		   && !in_array($this->data['option_data']['element_type'], array('M', 'G'))
		) {
			$dd                                              = new ADispatcher(
				'responses/product/product/stockLocations',
				array( (int) $this->request->get['product_id'], $product_option_value_id )
			);
			$this->data['form']['fields']['stock_locations'] =
				$dd->dispatchGetOutput( 'responses/product/product/stockLocations' );

			$resources_html               = $this->dispatch( 'responses/common/resource_library/get_resources_html' );
			$this->data['resources_html'] = $resources_html->dispatchGetOutput();
		}
		$this->view->batchAssign( $this->data );

		return $this->view->fetch( 'extensions/option_price_pro/admin/view/default/template/responses/product/option_value_row.tpl' );
	}

    /**
     * @param $product_id
     * @param $attribute_id
     * @param int $language_id
     * @return mixed
     */
	public function getProductOptionValues($product_id, $attribute_id, $language_id = 0 ) {
		if ( ! $language_id ) {
			$language_id = $this->language->getContentLanguageID();
		}
        $query = $this->db->query("SELECT pov.*, povd.name as value
               FROM `".$this->db->table('product_options')."` po
               LEFT JOIN `".$this->db->table('product_option_values')."` pov ON po.product_option_id = pov.product_option_id
               LEFT JOIN `".$this->db->table('product_option_value_descriptions')."` povd
                  ON ( pov.product_option_value_id = povd.product_option_value_id AND povd.language_id ='" . (int)$language_id . "' )
               WHERE po.attribute_id ='" . $this->db->escape( $attribute_id ) . "'
                   AND po.product_id=".(int)$product_id." 
               ORDER BY pov.sort_order");
        return $query->rows;
	}
}