<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";

/**
 * Class ControllerPagesExtensionStyleChanger
 * @property ModelExtensionStyleChangerLicenseInfo $model_extension_style_changer_license_info
 */

class ControllerPagesExtensionStyleChanger extends AController {
    private $error = [];
    public $data = [];

    public function verify() {
        if ($this->config->get('style_changer_status')==='1') {
            $this->load->model('extension/style_changer_license_info');
            $license_key = $this->config->get('style_changer_license_code');
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('style_changer_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_style_changer_license_info->getStoreId();
                    $license_key = $this->model_extension_style_changer_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_style_changer_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], 'style_changer');
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_style_changer_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }
    
    public function main() {

        $this->request->get['extension'] = 'style_changer';
        $this->loadLanguage( 'style_changer/style_changer' );
        $this->document->setTitle( $this->language->get( 'text_additional_settings' ) );
        $this->load->model( 'setting/setting' );

        if ( $this->request->is_POST() ) {
            $this->model_setting_setting->editSetting( 'style_changer', $this->request->post );
            $this->session->data['success'] = $this->language->get( 'text_success' );
            $content = html_entity_decode($this->request->post['style_changer_custom_css']);
            $file    = fopen( DIR_EXT . 'style_changer/storefront/view/default/stylesheet/custom.css', 'w' );
            fwrite( $file, $content );
            fclose( $file );
            $this->redirect( $this->html->getSecureURL( 'extension/style_changer' ) );
        }

        if ( isset( $this->error['warning'] ) ) {
            $this->data['error_warning'] = $this->error['warning'];
        } else {
            $this->data['error_warning'] = '';
        }
        $this->data['success'] = $this->session->data['success'];
        if ( isset( $this->session->data['success'] ) ) {
            unset( $this->session->data['success'] );
        }

        $this->document->initBreadcrumb( [
            'href'      => $this->html->getSecureURL( 'index/home' ),
            'text'      => $this->language->get( 'text_home' ),
            'separator' => false
        ] );

        $this->document->addBreadcrumb( [
            'href'      => $this->html->getSecureURL( 'extension/extensions/' ),
            'text'      => $this->language->get( 'text_style_changer' ),
            'separator' => ' :: '
        ] );

        $this->document->addBreadcrumb( [
            'href'      => $this->html->getSecureURL( 'extension/style_changer' ),
            'text'      => $this->language->get( 'style_changer_name' ),
            'separator' => ' :: ',
            'current'   => true
        ] );

        $this->data ['action']        = $this->html->getSecureURL( 'extension/style_changer', '&extension=style_changer' );
        $this->data['cancel']         = $this->html->getSecureURL( 'extension/extensions' );
        $this->data ['heading_title'] = $this->language->get( 'text_edit' ) . $this->language->get( 'text_style_changer' );
        $this->data ['form_title']    = $this->language->get( 'heading_title' );
        $this->data ['update']        = $this->html->getSecureURL( 'r/extension/style_changer_save/update' );

        $form = new AForm ( 'HS' );
        $form->setForm( [
            'form_name' => 'editFrm',
            'update'    => $this->data ['update']
        ] );

        $this->data['form']['form_open']                  = $form->getFieldHtml( [
            'type'   => 'form',
            'name'   => 'editFrm',
            'action' => $this->data ['action'],
            'attr'   => 'data-confirm-exit="true" class="aform form-horizontal"'
        ] );
        $this->data['form']['submit']                     = $form->getFieldHtml( [
            'type' => 'button',
            'name' => 'submit',
            'text' => $this->language->get( 'button_save' )
        ] );
        $this->data['form']['cancel']                     = $form->getFieldHtml( [
            'type' => 'button',
            'name' => 'cancel',
            'text' => $this->language->get( 'button_cancel' )
        ] );

        $this->data['form']['fields']['custom_css'] = $form->getFieldHtml( [
            'type'  => 'textarea',
            'name'  => 'style_changer_custom_css',
            'value' => $this->config->get('style_changer_custom_css'),
            'attr' => 'rows=30 colspan=20'
        ] );

        $this->data ['style_changer_addition_note']    = $this->language->get( 'style_changer_addition_note' );

        $this->data['groups'][]                 = 'additional_settings';
        $this->data['link_additional_settings'] = $this->data['add_sett']->href;
        $this->data['active_group']             = 'additional_settings';
        $this->data['license_status']           = $this->verify();
        $this->data['text_unauthorized']        = $this->language->get( 'text_style_changer_unauthorized' );

        $tabs_obj           = $this->dispatch( 'pages/extension/extension_tabs', [ $this->data ] );
        $this->data['tabs'] = $tabs_obj->dispatchGetOutput();
        unset( $tabs_obj );

        $obj                             = $this->dispatch( 'pages/extension/extension_summary', [ $this->data ] );
        $this->data['extension_summary'] = $obj->dispatchGetOutput();
        unset( $obj );
        $this->view->batchAssign( $this->data );

        $this->processTemplate( 'pages/extension/style_changer.tpl' );
    }
}